#include "difference_logic.h"

namespace lp {

	bool has_negative_cycle(
		int vertices, 
		const std::vector<std::tuple<int,int,double>>& edges, 
		std::vector<int>& cycle)
	{
		if (vertices <= 0) return false;
		std::vector<int> predecessor(vertices,-1);
		std::vector<double> distv(vertices,std::numeric_limits<double>::max()/2.0);
		distv.front() = 0;
		// Update vertices-1 times
		bool change = true;
		for (int k = 1; change && k < vertices; ++k) {
			change = false;
			for (auto& e : edges) {
				const double s = distv[std::get<0>(e)] + std::get<2>(e);
				if (s < distv[std::get<1>(e)]) {
					distv[std::get<1>(e)] = s;
					predecessor[std::get<1>(e)] = std::get<0>(e);
					change = true;
				}
			}
		}
		// Check for negative cycles
		for (auto& e : edges) {
			if (distv[std::get<0>(e)] + std::get<2>(e) < distv[std::get<1>(e)]) {
				// Negative cycle found
				cycle.clear();
				for (int v = std::get<0>(e); v != std::get<1>(e); v = predecessor[v]) {
					cycle.push_back(v);
				}
				return true;
			}
		}
		return false;
	}

}

